/*
 * Decompiled with CFR 0.152.
 */
import flanagan.io.FileChooser;
import flanagan.io.FileInput;
import flanagan.io.FileOutput;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class LifeGameFrame
extends JFrame
implements MouseListener,
MouseMotionListener,
ActionListener {
    protected final int gridCount = 100;
    protected int[][] grid = new int[100][100];
    private final int squareSize = 5;
    private final int gridSize = 500;
    private final int offSet = 50;
    private int penColor = 1;
    private Color[] colors;
    private Image ib;
    private Graphics ibg;
    private String filename;
    private Timer timmy;
    private boolean active = false;
    private int stepDelay = 500;
    private Color borderColor = new Color(20, 20, 20);
    private JButton buttonBlack;
    private JButton buttonClear;
    private JButton buttonOpen;
    private JButton buttonRefresh;
    private JButton buttonSave;
    private JButton buttonWhite;
    private JButton jButton1;
    private JButton jButton10;
    private JButton jButton11;
    private JButton jButton12;
    private JButton jButton2;
    private JButton jButton3;
    private JButton jButton4;
    private JButton jButton5;
    private JButton jButton6;
    private JButton jButton7;
    private JButton jButton8;
    private JButton jButton9;
    private JButton jButtonCopy;
    private JButton jButtonPaste;
    private JButton jButtonRun;
    private JButton jButtonStep;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JPanel jPanel3;
    private JScrollPane jScrollPane1;
    private JSlider jSliderDelay;
    private JTextField textInfo;

    public LifeGameFrame() {
        this.initComponents();
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.setUpImageBuffer();
        this.takeCareOfResizing();
        this.setUpColors();
        this.clearGrid();
        this.draw();
    }

    public void setUpImageBuffer() {
        this.ib = this.createImage(501, 501);
        this.ibg = this.ib.getGraphics();
    }

    public void takeCareOfResizing() {
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                LifeGameFrame.this.draw();
            }

            @Override
            public void componentMoved(ComponentEvent e) {
                LifeGameFrame.this.draw();
            }
        });
    }

    public void setUpColors() {
        this.colors = new Color[2];
        this.colors[0] = Color.darkGray;
        this.colors[1] = Color.white;
    }

    public void clearGrid() {
        for (int c = 0; c < 100; ++c) {
            for (int r = 0; r < 100; ++r) {
                this.grid[c][r] = 0;
            }
        }
        this.draw();
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        int row = (y - 50) / 5;
        int col = (x - 50) / 5;
        System.out.println("Click: " + col + ", " + row);
        if (row >= 0 && row < 100 && col >= 0 && col < 100) {
            this.clickGrid(col, row);
        }
    }

    @Override
    public void mouseDragged(MouseEvent e) {
        int x = e.getX();
        int y = e.getY();
        int row = (y - 50) / 5;
        int col = (x - 50) / 5;
        System.out.println("Drag:  " + col + ", " + row);
        if (row >= 0 && row < 100 && col >= 0 && col < 100) {
            this.dragGrid(col, row);
        }
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }

    public void colorSquare(int col, int row, int colorValue) {
        this.grid[col][row] = colorValue;
        this.draw();
    }

    public void clickGrid(int col, int row) {
        this.colorSquare(col, row, this.penColor);
    }

    public void dragGrid(int col, int row) {
        this.colorSquare(col, row, this.penColor);
    }

    public void draw() {
        this.ibg.clearRect(0, 0, 500, 500);
        this.ibg.setColor(Color.white);
        this.ibg.fillRect(0, 0, 500, 500);
        this.drawSquares(this.ibg);
        this.ibg.setColor(Color.black);
        this.ibg.drawRect(0, 0, 500, 500);
        Graphics g = this.getGraphics();
        g.drawImage(this.ib, 50, 50, this);
    }

    public void drawSquares(Graphics g) {
        g.setColor(Color.black);
        for (int r = 0; r < 100; ++r) {
            for (int c = 0; c < 100; ++c) {
                g.setColor(this.colors[this.grid[c][r]]);
                g.fillRect(c * 5, r * 5, 5, 5);
                g.setColor(this.borderColor);
                g.drawRect(c * 5, r * 5, 5, 5);
            }
        }
    }

    private void initComponents() {
        this.textInfo = new JTextField();
        this.jScrollPane1 = new JScrollPane();
        this.jPanel3 = new JPanel();
        this.buttonOpen = new JButton();
        this.buttonSave = new JButton();
        this.buttonRefresh = new JButton();
        this.buttonClear = new JButton();
        this.buttonBlack = new JButton();
        this.buttonWhite = new JButton();
        this.jButtonStep = new JButton();
        this.jButtonCopy = new JButton();
        this.jButtonPaste = new JButton();
        this.jButtonRun = new JButton();
        this.jSliderDelay = new JSlider();
        this.jPanel1 = new JPanel();
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        this.jButton3 = new JButton();
        this.jButton4 = new JButton();
        this.jButton5 = new JButton();
        this.jButton6 = new JButton();
        this.jButton7 = new JButton();
        this.jButton8 = new JButton();
        this.jButton9 = new JButton();
        this.jButton10 = new JButton();
        this.jButton11 = new JButton();
        this.jButton12 = new JButton();
        this.jLabel1 = new JLabel();
        this.setDefaultCloseOperation(3);
        this.setBackground(new Color(255, 255, 51));
        this.setMinimumSize(new Dimension(950, 660));
        this.textInfo.setFont(new Font("Tahoma", 0, 14));
        this.textInfo.setText("give user info here...");
        this.buttonOpen.setFont(new Font("Tahoma", 1, 12));
        this.buttonOpen.setText("Open");
        this.buttonOpen.setPreferredSize(new Dimension(100, 20));
        this.buttonOpen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LifeGameFrame.this.buttonOpenActionPerformed(evt);
            }
        });
        this.buttonSave.setFont(new Font("Tahoma", 1, 12));
        this.buttonSave.setText("Save");
        this.buttonSave.setPreferredSize(new Dimension(100, 20));
        this.buttonSave.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LifeGameFrame.this.buttonSaveActionPerformed(evt);
            }
        });
        this.buttonRefresh.setFont(new Font("Tahoma", 1, 12));
        this.buttonRefresh.setText("Refresh");
        this.buttonRefresh.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LifeGameFrame.this.buttonRefreshActionPerformed(evt);
            }
        });
        this.buttonClear.setFont(new Font("Tahoma", 1, 12));
        this.buttonClear.setText("Clear");
        this.buttonClear.setPreferredSize(new Dimension(100, 20));
        this.buttonClear.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LifeGameFrame.this.buttonClearActionPerformed(evt);
            }
        });
        this.buttonBlack.setFont(new Font("Tahoma", 0, 10));
        this.buttonBlack.setText("BLACK");
        this.buttonBlack.setMaximumSize(new Dimension(50, 30));
        this.buttonBlack.setMinimumSize(new Dimension(75, 0));
        this.buttonBlack.setPreferredSize(new Dimension(50, 20));
        this.buttonBlack.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LifeGameFrame.this.buttonBlackActionPerformed(evt);
            }
        });
        this.buttonWhite.setFont(new Font("Tahoma", 0, 10));
        this.buttonWhite.setText("WHITE");
        this.buttonWhite.setMaximumSize(new Dimension(50, 30));
        this.buttonWhite.setMinimumSize(new Dimension(75, 0));
        this.buttonWhite.setPreferredSize(new Dimension(50, 20));
        this.buttonWhite.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LifeGameFrame.this.buttonWhiteActionPerformed(evt);
            }
        });
        this.jButtonStep.setText("STEP");
        this.jButtonStep.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LifeGameFrame.this.jButtonStepActionPerformed(evt);
            }
        });
        this.jButtonCopy.setText("Copy");
        this.jButtonPaste.setText("Paste");
        this.jButtonRun.setText("Run");
        this.jButtonRun.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LifeGameFrame.this.jButtonRunActionPerformed(evt);
            }
        });
        this.jSliderDelay.setFont(new Font("Tahoma", 0, 8));
        this.jSliderDelay.setMajorTickSpacing(500);
        this.jSliderDelay.setMaximum(2000);
        this.jSliderDelay.setMinorTickSpacing(500);
        this.jSliderDelay.setPaintLabels(true);
        this.jSliderDelay.setPaintTicks(true);
        this.jSliderDelay.setSnapToTicks(true);
        this.jSliderDelay.setValue(500);
        this.jSliderDelay.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                LifeGameFrame.this.jSliderDelayStateChanged(evt);
            }
        });
        this.jButton1.setText("jButton1");
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LifeGameFrame.this.jButton1ActionPerformed(evt);
            }
        });
        this.jButton2.setText("jButton2");
        this.jButton3.setText("jButton3");
        this.jButton4.setText("jButton4");
        this.jButton5.setText("jButton5");
        this.jButton6.setText("jButton6");
        this.jButton7.setText("jButton7");
        this.jButton8.setText("jButton8");
        this.jButton9.setText("jButton9");
        this.jButton10.setText("jButton10");
        this.jButton11.setText("jButton11");
        this.jButton12.setText("jButton12");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jButton1, -1, 166, Short.MAX_VALUE).addComponent(this.jButton2, -1, -1, Short.MAX_VALUE).addComponent(this.jButton3, -1, -1, Short.MAX_VALUE).addComponent(this.jButton4, -1, -1, Short.MAX_VALUE).addComponent(this.jButton5, -1, -1, Short.MAX_VALUE).addComponent(this.jButton6, -1, -1, Short.MAX_VALUE).addComponent(this.jButton7, -1, -1, Short.MAX_VALUE).addComponent(this.jButton8, -1, -1, Short.MAX_VALUE).addComponent(this.jButton9, -1, -1, Short.MAX_VALUE).addComponent(this.jButton10, -1, -1, Short.MAX_VALUE).addComponent(this.jButton11, -1, -1, Short.MAX_VALUE).addComponent(this.jButton12, -1, -1, Short.MAX_VALUE)).addGap(0, 10, Short.MAX_VALUE)));
        jPanel1Layout.linkSize(0, this.jButton1, this.jButton10, this.jButton11, this.jButton12, this.jButton2, this.jButton3, this.jButton4, this.jButton5, this.jButton6, this.jButton7, this.jButton8, this.jButton9);
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jButton1).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButton2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButton3).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButton4).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButton5).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButton6).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButton7).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButton8).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButton9).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButton10).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButton11).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButton12).addGap(0, 9, Short.MAX_VALUE)));
        this.jLabel1.setFont(new Font("Tahoma", 0, 10));
        this.jLabel1.setText("set delay");
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSliderDelay, -2, 324, -2).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.buttonSave, -1, 114, Short.MAX_VALUE).addComponent(this.buttonClear, -1, -1, Short.MAX_VALUE).addComponent(this.buttonRefresh, -1, -1, Short.MAX_VALUE).addComponent(this.buttonBlack, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonStep, -1, -1, Short.MAX_VALUE).addComponent(this.buttonWhite, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonCopy, -1, -1, Short.MAX_VALUE).addComponent(this.jButtonPaste, -1, -1, Short.MAX_VALUE).addComponent(this.buttonOpen, -2, 132, -2).addComponent(this.jButtonRun, -2, 113, -2)).addGap(28, 28, 28).addComponent(this.jPanel1, -2, -1, -2)))).addGroup(jPanel3Layout.createSequentialGroup().addGap(156, 156, 156).addComponent(this.jLabel1))).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel3Layout.linkSize(0, this.buttonBlack, this.buttonClear, this.buttonOpen, this.buttonRefresh, this.buttonSave, this.buttonWhite, this.jButtonCopy, this.jButtonPaste, this.jButtonRun, this.jButtonStep);
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -2, -1, -2).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.buttonOpen, -2, 27, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonSave, -2, 27, -2).addGap(46, 46, 46).addComponent(this.buttonClear, -1, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.buttonRefresh).addGap(18, 18, 18).addComponent(this.jButtonCopy).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonPaste).addGap(20, 20, 20).addComponent(this.buttonBlack, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buttonWhite, -2, -1, -2).addGap(42, 42, 42).addComponent(this.jButtonStep).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jButtonRun))).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jSliderDelay, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel1).addContainerGap(184, Short.MAX_VALUE)));
        jPanel3Layout.linkSize(1, this.buttonBlack, this.buttonWhite);
        jPanel3Layout.linkSize(1, this.buttonClear, this.buttonRefresh);
        this.jScrollPane1.setViewportView(this.jPanel3);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.textInfo, -1, 930, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jScrollPane1, -2, 359, -2))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1, -2, 559, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.textInfo, -2, 36, -2).addContainerGap(18, Short.MAX_VALUE)));
        this.pack();
    }

    private void buttonSaveActionPerformed(ActionEvent evt) {
        FileChooser FC = new FileChooser();
        FC.selectFile();
        this.filename = FC.getDirPath() + "/" + FC.getFileName();
        System.out.println("Filename: " + this.filename);
        FC.close();
        FileOutput FO = new FileOutput(this.filename, "w");
        for (int r = 0; r < 100; ++r) {
            for (int c = 0; c < 100; ++c) {
                int num = this.grid[c][r];
                if (num < 10) {
                    FO.print("0" + num);
                    continue;
                }
                FO.print(num);
            }
            FO.println("");
        }
        FO.close();
    }

    private void buttonOpenActionPerformed(ActionEvent evt) {
        FileChooser FC = new FileChooser();
        FC.selectFile();
        this.filename = FC.getDirPath() + "/" + FC.getFileName();
        System.out.println(this.filename);
        FC.close();
        FileInput FI = new FileInput(this.filename);
        int num = FI.numberOfLines();
        if (num != 100) {
            System.out.println("Not enough lines in file!");
            return;
        }
        for (int r = 0; r < 100; ++r) {
            String line = FI.readLine();
            for (int c = 0; c < 100; ++c) {
                int value;
                String temp = line.substring(c * 2, c * 2 + 2);
                this.grid[c][r] = value = Integer.parseInt(temp);
            }
        }
        FI.close();
        this.draw();
    }

    private void buttonRefreshActionPerformed(ActionEvent evt) {
        this.draw();
    }

    private void buttonClearActionPerformed(ActionEvent evt) {
        this.clearGrid();
    }

    private void buttonBlackActionPerformed(ActionEvent evt) {
        this.penColor = 0;
    }

    private void buttonWhiteActionPerformed(ActionEvent evt) {
        this.penColor = 1;
    }

    public boolean isAlive(int c, int r) {
        if (c < 0 || r < 0 || c >= 100 || r >= 100) {
            return false;
        }
        return this.grid[c][r] != 0;
    }

    private void jButtonStepActionPerformed(ActionEvent evt) {
        this.step();
    }

    public int countNeighbors(int c, int r) {
        return 0;
    }

    public void step() {
        int col = (int)(Math.random() * 100.0);
        int row = (int)(Math.random() * 100.0);
        this.grid[col][row] = 1;
        this.draw();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        System.out.println("Calling Step...");
        System.out.println(e.getSource());
        this.step();
    }

    private void jButtonRunActionPerformed(ActionEvent evt) {
        System.out.println("Run/Pause Button Pressed");
        if (!this.active) {
            if (this.timmy == null) {
                this.timmy = new Timer(this.stepDelay, this);
                this.timmy.setInitialDelay(100);
                this.timmy.setDelay(this.stepDelay);
            }
            this.timmy.start();
            this.active = true;
            this.jButtonRun.setText("Pause...");
        } else {
            this.active = false;
            this.timmy.stop();
            this.jButtonRun.setText("Run...");
        }
    }

    private void jSliderDelayStateChanged(ChangeEvent evt) {
        this.stepDelay = this.jSliderDelay.getValue();
        if (this.stepDelay == 0) {
            this.stepDelay = 1;
        }
        if (this.timmy != null) {
            this.timmy.setDelay(this.stepDelay);
        }
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        int[][] A = new int[3][5];
        System.out.println(A.length);
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new LifeGameFrame().setVisible(true);
            }
        });
    }
}

