import java.util.ArrayList;
import java.util.Iterator;

public class Runner {
    
    public static void main(String[] args) {
        ArrayList<Student> students=new ArrayList<>();
        
        String[] names={"Adam", "Bob", "Celine", "Dennis", "Effie", "Frank", "Georgia"};
        
        //print array out
        System.out.println("For each with array...");
        for(String s: names){
            System.out.println(s);
        }
        
        //fill arraylist
         for(int k=0; k<6; k++) {
            int a=(int)(Math.random()*5)+12;
            String n=names[k];
            Student temp=new Student(n,a);
            students.add(temp);
        }
     
        //print each student in arraylist 
        System.out.println("For each with List (any list of Iterables)");
        for(Student stud: students) {
            System.out.println(stud.getName() + " " + stud.age);
        }
        
        //modifying the objects is ok
        for(Student stud: students) {
            stud.age++;
        }
        
        //accessing objects members is ok
        System.out.println("For each showing modified students...");
        for(Student stud: students){
            System.out.println(stud.getName() + " " + stud.age);
        }
        
        //removing or inserting is bad since it messes up the iteration
        //once it gets started, the list cannot change
        /*for(Student temp: students) {
            if (temp.age<16) {
                students.remove(temp);
            }
        }
        */
        
        //use Iterator to cycle through items
        System.out.println("Iterator with WHILE LOOP...");
        Iterator<Student> iter=students.iterator();
        while(iter.hasNext()) {
          Student temp=iter.next();
          System.out.println(temp.getName() );
        }
 
        //Iterator with for loop: this is basically the for each loop in long form
        System.out.println("Iterator with FOR LOOP...");
        for(Iterator<Student> iterat = students.iterator(); iterat.hasNext(); ) {
            Student stud = iterat.next();
            System.out.println(stud.getName());
            if (stud.age<16) {
                System.out.println("Removing " + stud.getName() );
                iterat.remove();
            } 
        }
        
        
        //show list one last time...
        System.out.println("Final student list...");
        for(Student stud: students){
            System.out.println(stud.getName() + " " + stud.age);
        }
        
        
    }//end main
}//end class
