package StudentTeacher01;

import java.util.ArrayList;

public class TestSchool {
    
    ArrayList<Person> roster = new ArrayList<Person>();
    
    public TestSchool(){
      Person Andrew = new Person("Andrew", 8);
      Student Hazel = new Student("Hazel", 17, 12345);
      ExchangeStudent Rico = new ExchangeStudent("Rico", 16, 8787);
      Student Ben = new Student("Ben", 8, 38292);
      ExchangeStudent Sven = new ExchangeStudent("Sven", 15, 64646);
      Teacher Janetka = new Teacher("Janetka", 44);
      roster.add(Andrew);roster.add(Hazel);roster.add(Rico);
      roster.add(Ben);roster.add(Sven);roster.add(Janetka);
    }
    
    public void addPersonToRoster(Person P){
        roster.add(P);
    }
    
    public void addStudentToRoster(Student S) {
        roster.add(S);
    }
    
    public Person pickRandomIndividual(){
        int r = (int)(Math.random()*roster.size());
        Person P = roster.get(r);
        return(P);
    }
    
    public void getReturnDateOfFirstExchangeStudent() {
        for(int k=0; k<roster.size(); k++){
          Person temp = roster.get(k);
          if (temp instanceof ExchangeStudent) {
             String date =  ((ExchangeStudent)temp).getReturnDate();
             System.out.println(date);
             return;
          }
        }
        System.out.println("No Exchange Student Found!");
    }
    
    public ExchangeStudent getFirstExchangeStudent() {
       for(int k=0; k<roster.size(); k++){
          Person temp = roster.get(k);
          if (temp instanceof ExchangeStudent) {
             return( (ExchangeStudent)temp);
          }
        }
        return(null);       
    }
    
    
    public void showRoster(){
        for(int k=0; k<roster.size(); k++) {
            Person temp=roster.get(k);
            System.out.print(temp.name + "   ");
            temp.talk();
        }
    }
    
}
